#ifndef _CREST_SOFTKEYS_H__
#define _CREST_SOFTKEYS_H__

#include <linux/types.h>
#include <linux/mutex.h>
#include <linux/input.h>
#include <linux/ft5x06_i2c_defs.h>

#define UIHAL_MAX_TOUCH_POINTS_SUPPORTED 2
#define CREST_SOFTKEYS_NUM_COORDINATES 2    /* Supports 2 for now, (x,y) */

//TODO: Remove this global structure.
extern struct mutex *keyStateMutex; //mutex lock for gVbKeyStates
extern unsigned int gVbKeyStates;
extern int g_virt_dbg_keys;  //set default back keys....
extern unsigned int g_disableInputEvents;

struct UiHalTouch {
        int touchId;
        int pressState;
        int xPosition;
        int yPosition;
};

/**
 * state is 0 for touch-up, 1 for touchdown in touch-area, 2-6 for touchdown in each virtual key.
 */
struct crest_xydata_t {
	u16 pos[CREST_SOFTKEYS_NUM_COORDINATES] __attribute__ ((packed));
	u8 state;
};

/* maximum number of track IDs */
#define CRESTRON_MAX_NUM_TOUCHES		10

/**
 *  This structure contains the common information that needs to be shared
 * between the two touch drivers ft5x06_ts and etml_ts.
 */
struct crestSoftKeys_ctrl_t {
	struct input_dev *ts_dev;
	struct input_dev *key_dev;
	struct softkey_area softkeys;
	struct crest_xydata_t prv_tch[CRESTRON_MAX_NUM_TOUCHES];
	u32 maxy;
	int y_bottom_cap;
};

int crestSoftKeys_init(struct crestSoftKeys_ctrl_t *ctrl);
void crestSoftKeys_processTouchData(struct crestSoftKeys_ctrl_t *ctrl, int touchId, struct crest_xydata_t touch, bool forceSend);

#endif /* _CREST_SOFTKEYS_H__*/
